﻿// Control UI is located in _DisableDateControl.cshtml

var a4DisableDatesControl = function () {
    var _container = null;
    var _controlRoot = null;
	var _calendar = null;
	var _enabledWeekDays = null;
	var _disabledDatesInDateRanges = null;
	var _dateFormat = null;

	init = function (container, dateFormat) {
	    inputSetup(container, dateFormat);
        registerEvents();
	}

	inputSetup = function (container, dateFormat) {
	    _container = container;
	    _controlRoot = ".h-disableDateControlRoot"
	    _calendar = ".h-disabledDatesCalendar";
	    _dateFormat = dateFormat;

	    $(_calendar, _container).multiDatesPicker({
	        onSelect: updateSelectedDaysListbox,
	        beforeShowDay: updateCalendarWeekDaysPossibleSelection,	        
	        dateFormat: _dateFormat
	    });
	    
	    updateEnabledWeekDays();
	    updateDisabledDatesInRanges();

	    $(_calendar, _container).multiDatesPicker('resetDates');

	    $('.h-single-days input').each(function () {
	        $(_calendar, _container).multiDatesPicker('addDates', $(this).val());
	    });
	    $(".h-single-days").remove();

	    updateSelectedDaysListbox();

	    $(".DateRangeRow input[type='text']").each(function () {
	        setDatePicker($(this), _dateFormat);
	    });

	    toggleDateRangeHeaderVisibility();
	}

	registerEvents = function () {
	    registerSelectListBoxItemOnClick();
	    registerDateRangeDelete();
	    registerClearAllInListBox();
	    registerDeleteDateInListBox();
	    registerUpdateCalendarOnWeekDayChange();
	    registerUpdateCalendarOnDateRangeChange();
	    registerAddDateRange();
	}

	registerSelectListBoxItemOnClick = function () {
	    $(_controlRoot).on('click', '.disabled-date', function () {
	        $(this).toggleClass('selected');
	    });
	}

	registerDateRangeDelete = function () {
	    $(_controlRoot).on('click', '.h-deleteRow', function () {
	        $(this).closest('.DateRangeRow').remove();
	        toggleDateRangeHeaderVisibility();
	        updateDisabledDatesInRanges();
	        $(_calendar, _container).datepicker('refresh');
	    });
	}

	registerClearAllInListBox = function () {
	    $(_controlRoot).on('click', '.h-clearAllDisabledDates', function () {
	        $(".h-disabledDatesList", _container).empty();
	        $(_calendar, _container).multiDatesPicker('resetDates');
	    });
	}

	registerDeleteDateInListBox = function () {
	    $(_controlRoot).on('click', '.h-removeDisabledDate', function () {
	        var selectedListboxItems = $('.disabled-date.selected', _container);
	        var selectedListboxDates = $('.disabled-date.selected', _container).map(function () { return $(this).attr('data-value'); }).get();
	        $(_calendar, _container).multiDatesPicker('removeDates', selectedListboxDates);
	        selectedListboxItems.remove();
	    });
	}

	registerUpdateCalendarOnDateRangeChange = function () {
	    // OnClose event is used here, instead of 'OnChange' because of a limitation of jquery-ui.
	    // The datepicker refresh event does not trigger properly when more than one calender control is visible at the same time.
	    $(".fromField input, .toField input", _container).datepicker("option", "onClose", function () {
	        updateDisabledDatesInRanges();
	        $(_calendar, _container).datepicker('refresh');
	    });
	}

	registerUpdateCalendarOnWeekDayChange = function () {
        $(".v-calendar-days input", _container).on("change", function () {
	        updateEnabledWeekDays();
	        $(_calendar, _container).datepicker('refresh');
	    });
	}

	registerAddDateRange = function () {
	    $(_container).off('click', '#h-AddRangeButton').on('click', '#h-AddRangeButton', function () {
	        var newRow = $(".DateRangeRow.template:first").clone(true).removeClass("hidden template");
	        $('.DateRangeRow').last().after(newRow);
	        $(".DateRangeRow:last input").each(function () {
	            $(this).removeAttr('id').removeAttr('name').removeClass('hasDatepicker');
	            $(this).val("");
	            updateDisabledRangesIndexes();
	            setDatePicker($(this), _dateFormat);
	            registerUpdateCalendarOnDateRangeChange();
	        });
	        toggleDateRangeHeaderVisibility();
	    });
	}

	toggleDateRangeHeaderVisibility = function () {
	    if ($(".dateRangeRoot .DateRangeRow:not('.template')").length > 0) {
	        $(".dateRangeRoot").find("thead").removeClass("hidden");
	    } else{
	        $(".dateRangeRoot").find("thead").addClass("hidden");
	    }
	}

	updateSelectedDaysListbox = function () {
	    var dates = getSelectedDates();
	    $(".h-disabledDatesList", _container).empty();
	    _.each(dates, function (date) {
	        $(".h-disabledDatesList", _container).append($("<div />", { "class": "disabled-date ", "data-value": date }).append(date));
	    });
	}

	setDatePicker = function (input, format) {
		if (input.hasClass("hasDatepicker")) {
			input.datepicker('destroy');
		}

		input.datepicker({
			changeMonth: true,
			changeYear: true,
			dateFormat: format
		});
	}

	updateDisabledDatesInRanges = function () {
	    _disabledDatesInDateRanges = [];
	    dateFormat = getDateFormatForMomentJS();
	    
	    $(".DateRangeRow:not('.hidden')", _container).each(function () {
	        startDate = $(".fromField input", this).val();
	        endDate = $(".toField input", this).val();

	        if (startDate == "" || endDate == "")
	            return true;

	        formatedStartDate = moment(startDate, dateFormat);
	        formatedEndDate = moment(endDate, dateFormat).add(1, 'days');

            while (formatedEndDate > formatedStartDate && !formatedStartDate.isSame(formatedEndDate)){
	            _disabledDatesInDateRanges.push(formatedStartDate.format(dateFormat));
	            formatedStartDate = formatedStartDate.add(1, 'days');
	        }
	    });
	}

	updateEnabledWeekDays = function () {
	    _enabledWeekDays = [];
	    $(".js-weekday-toggle-visible input[type=checkbox]", _container).each(function () {
	        if ($(this).is(":checked") == false) {
	            _enabledWeekDays.push($(this).attr("data-index"));
	        }
	    });

        // Hidden weekday toggles should not disable dates in the calendar, they always are enabled.
	    $(".v-calendar-days .js-weekday-toggle-hidden input", _container).each(function () {
	        _enabledWeekDays.push($(this).attr("data-index"));
	    });
	}

	updateDisabledRangesIndexes = function () {
		i = 0;
		$(".DateRangeRow:not('.hidden')", _container).each(function (row) {
		    $(".fromField input", this).attr('name', "DisabledRanges[" + i.toString() + "].From");
		    $(".fromField input", this).attr('id', "DisabledRanges_" + i.toString() + "__From");
		    $(".toField input", this).attr('name', "DisabledRanges[" + i.toString() + "].To");
		    $(".toField input", this).attr('id', "DisabledRanges_" + i.toString() + "__To");
			i = i + 1;
		});
	}

	updateCalendarWeekDaysPossibleSelection = function (date) {
		EnabledDate = true;
		DisabledDate = false;
		var day = date.getDay();
		var formatedDate = moment(date).format(getDateFormatForMomentJS());
		if ($.inArray(day.toString(), _enabledWeekDays) > -1 && $.inArray(formatedDate, _disabledDatesInDateRanges) < 0) {
			return [EnabledDate, ''];
		}
		else {
			return [DisabledDate, ''];
		}
	}

    hide = function () {
        if ($(_controlRoot, _container).closest(".ui-control-container"))
		    $(_controlRoot, _container).closest(".ui-control-container").hide();
	}

    show = function () {
        if ($(_controlRoot, _container).closest(".ui-control-container"))
	        $(_controlRoot, _container).closest(".ui-control-container").show();
	}

	toObject = function () {
	    var disabledDate = {
	        ranges: getDateRanges(),
	        dates: getSelectedDates(),
            weekdays: getSelectedWeekdays()
	    };
	    return disabledDate;
	}

	toJSON = function () {
	    return JSON.stringify(toObject());
	}

	getSelectedWeekdays = function () {
	    var weekdays = [];
	    $(".v-calendar-days input:visible", _container).each(function () {
            var dayOfWeek = $(this).attr('data-text');
            if ($(this).prop('checked'))
                weekdays.push(dayOfWeek);
        });
        return weekdays;
    }

	getDateRanges = function () {
	    var ranges = [];
	    $(".DateRangeRow:not('.hidden')", _container).each(function () {
	        var start = $(".fromField input", this).val()
	        var end = $(".toField input", this).val()
	        ranges.push({ start: start, end: end });
	    });
	    return ranges;
	}

	getSelectedDates = function () {
	    return $(_calendar, _container).multiDatesPicker('getDates');
	}

	clearAll = function () {
	    $(".DateRangeRow:not('.template')", _container).remove();
	    $(".disabled-date", _container).remove();
	    $(".v-calendar-days input:visible", _container).each(function () {
	        $(this).prop('checked', false);
	    });
	    updateEnabledWeekDays();
	    toggleDateRangeHeaderVisibility();
	}

	changeDateFormat = function (format) {
	    clearAll();
	    $(_calendar, _container).datepicker('destroy');
	    $(_calendar, _container).multiDatesPicker('destroy');
	    $(".DateRangeRow:has('.template')", _container).datepicker('destroy');
	    inputSetup(_container, format);
    }

	isValid = function () {
	    valid = true;
	    $(".DateRangeRow:visible").each(function () {
	        var fromValue = $('.fromField', this).find('input').val()
	        var toValue = $('.toField', this).find('input').val()
	        if (fromValue == '' || toValue == '')
	            valid = false;

	        var fromDate = new Date(fromValue);
	        var toDate = new Date(toValue);

	        if (toDate <= fromDate)
	            valid = false;
	        });
	    return valid;
	}

	updateMinDate = function (minDateString) {
	    $(_calendar, _controlRoot).datepicker('option', 'minDate', minDateString);
	}

	updateMaxDate = function (updateMaxDate) {
	    $(_calendar, _controlRoot).datepicker('option', 'maxDate', updateMaxDate);
	}

	today = function () {
	    var today = new Date();
	    return moment(today).format(getDateFormatForMomentJS());
	}

	getDateFormatForMomentJS = function () {
	    return _dateFormat.replace(/y/g, "yy").toUpperCase();
	}

	return {
	    init: init,
	    hide: hide,
	    show: show,
	    toObject: toObject,
	    toJSON: toJSON,
	    clearAll: clearAll,
	    changeDateFormat: changeDateFormat,
	    isValid: isValid,
	    updateMinDate: updateMinDate,
	    updateMaxDate: updateMaxDate,
	    today: today
	};

}